#include "LCD.h"
#include "hardware.h"

void LCD_setup()
{
	Delay(50000); 						// power-up delay
	PTA->PSOR = LCD_RST;				// pull LCD Reset up
	Delay(20000);						// 20 ms delay
	LCD_command(0x38);					// wake-up
	LCD_command(0x39);					// function set
	LCD_command(0x14);					// internal osc frequency
	LCD_command(0x78);					// set contrast
	LCD_command(0x5E);					// power control
	LCD_command(0x6D);					// follower control	
	Delay(60000);
	Delay(60000);
	Delay(60000);
	Delay(60000);
	LCD_command(0x0C);					// LCD on
	LCD_command(0x01);					// clear LCD
	Delay(3000);
	LCD_command(0x06);					// entry mode
	Delay(10000);
}

void LCD_command(uint8_t d)
{
	PTA->PCOR = LCD_CS;					// CS down
	PTA->PCOR = LCD_RS;					// sending command
	SPI_send(d);
	PTA->PSOR = LCD_CS;					// CS up	
}

void LCD_data(uint8_t d)
{
	PTA->PCOR = LCD_CS;					// CS down
	PTA->PSOR = LCD_RS;					// sending data
	SPI_send(d);
	PTA->PSOR = LCD_CS;					// CS up	
}

void LCD_setCursor(uint8_t row, uint8_t col)
{
	if (!row)							// bottom row
		LCD_command(0x80 + col);
	else								// top row
		LCD_command(0xC0 + col);
}

void LCD_writeString(const char *s)
{
	uint8_t i = 0;
	PTA->PCOR = LCD_CS;					// CS down
	PTA->PSOR = LCD_RS;					// sending data
	while (s[i])
	{
		SPI_send(s[i]);
		i++;
	}
	PTA->PSOR = LCD_CS;					// CS up
}

void LCD_writeInt(int32_t n)			// write integer
{
	uint8_t digits[8];
	int8_t len = -1;
	if (n < 0)
	{
		n = -n;
		LCD_writeString("-");
	}
	
	do {
		len++;
		digits[len] = (n % 10) + '0';	// ASCII conversion		
		n = n / 10;
	} while (n);
	
	PTA->PCOR = LCD_CS;					// CS down
	PTA->PSOR = LCD_RS;					// sending data
	do {
		SPI_send(digits[len]);
		len--;
	} while(len >= 0);
	PTA->PSOR = LCD_CS;					// CS up
}

void delay50(void)
{
	int i = 100;
	for (; i>=0; i--){}
}

void Delay(uint32_t i)
{
	TPM1->MOD = i;						
	TPM1->SC = TPM_SC_PS(2) | TPM_SC_TOF_MASK | TPM_SC_TOIE_MASK | TPM_SC_CMOD(1);	// start timer
	__WFI();			
}
